using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
	public partial class VTA_PATIENT_ICD9DB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public VTA_PATIENT_ICD9DB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public VTA_PATIENT_ICD9 GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 VTA_PATIENT_ICD9_ID)
		{
			VTA_PATIENT_ICD9 objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_VTA_PATIENT_ICD9_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, VTA_PATIENT_ICD9_ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<VTA_PATIENT_ICD9> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<VTA_PATIENT_ICD9> objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_VTA_PATIENT_ICD9_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, VTA_PATIENT_ICD9 objSave)
		{
			Int32? objReturn = objSave.VTA_PATIENT_ICD9_ID;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_VTA_PATIENT_ICD9_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.ICD9_CODE, objSave.VTA_ICD9_CODE, objSave.VTA_ID, ref objReturn);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 VTA_PATIENT_ICD9_ID)
		{
			Boolean objReturn = false;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_VTA_PATIENT_ICD9_delete(CURRENT_USER, CURRENT_REGISTRY_ID, VTA_PATIENT_ICD9_ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		#endregion
	}
}
